﻿<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="System.Collections.Generic" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.SrodkiTrwale" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<TITLE>Użytkownika/Podsumowanie grup wg stawek</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script runat="server">
			void OnLoad(Object sender, EventArgs args) {
				SrodkiTrwale.Params p = (SrodkiTrwale.Params)dc[typeof(SrodkiTrwale.Params)];
				ActualDate aktualnosc = (ActualDate)dc[typeof(ActualDate)];				
				ReportHeader.Title =
					string.Format("Podsumowanie grup wg stawek|Aktualność: {5} Typ: {0}|Stan: {1} Rodzaj: {2}|MiejsceUzytkowania: {3}|Odpowiedzialny: {4}",
					p.Typ, p.Stan,p.Rodzaj == null ? "Wszystkie" : p.Rodzaj.ToString(), p.MiejsceUzytkowania == null ? "Wszystkie" : p.MiejsceUzytkowania.ToString(),
					p.Odpowiedzialny == null ? "Wszystkie" : p.Odpowiedzialny.ToString(), aktualnosc.Actual);
				Row[] rows = (Row[])dc[typeof(Row[])];

				System.Collections.Generic.SortedDictionary<string, SumaStawki> dict = new SortedDictionary<string, SumaStawki>();
				WartosciSrodkaWorker wsw = new WartosciSrodkaWorker();
				wsw.Data = aktualnosc.Actual;
				
				foreach (Row row in rows) {
					SrodekTrwalyBase s = (SrodekTrwalyBase)row;
					SrodekTrwalyBaseHistoria sh = s[aktualnosc.Actual];
					string ident = SumaStawki.GrupaAmortyzacjaToString(sh.KRST.GrupaSymbol, sh.Bilansowa);
					SumaStawki suma = null;

					if (dict.ContainsKey(ident))
						suma = dict[ident];
					
					if (suma == null) {
						suma = new SumaStawki(sh.KRST.GrupaSymbol, sh.Bilansowa);
						dict.Add(ident, suma);
					}
					
					wsw.SrodekHistoria = sh;
					suma.Add(wsw.WartoscBilansowa);
				}
				

				Grid.DataSource = dict.Values;
			}
		
			public class SumaStawki{
				string grupa;
				ParametryAmortyzacji amortyzacja;
				Currency wartosc = Currency.Zero;
				
				public SumaStawki(string grupa, ParametryAmortyzacji amortyzacja) {
					this.grupa = grupa;
					this.amortyzacja = amortyzacja;					
				}

				public string Grupa {
					get { return grupa; }
				}

				public ParametryAmortyzacji Amortyzacja {
					get { return amortyzacja; }
				}

				public string GrupaAmortyzacja {
					get { return GrupaAmortyzacjaToString( grupa, amortyzacja); }
				}
				
				static public string GrupaAmortyzacjaToString(string grupa,ParametryAmortyzacji amortyzacja){
					return string.Format("{0}{1}{2}", grupa, amortyzacja.Metoda, amortyzacja.Stawka);
				}

				public Currency Wartosc {
					get { return wartosc; }
				}				
				
				internal void Add(Currency value){
					wartosc += value;
				}
			}
		

				
		</script>
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" OnContextLoad="OnLoad" runat="server"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" runat="server" title="Podsumowanie grup wg stawek|Aktualność: {5} Typ: {0}|Stan: {1} Rodzaj: {2}|MiejsceUzytkowania: {3}|Odpowiedzialny: {4}" DataMember0="SrodkiTrwale+Params.Typ" DataMember1="SrodkiTrwale+Params.Stan" DataMember2="SrodkiTrwale+Params.Rodzaj" DataMember3="SrodkiTrwale+Params.MiejsceUzytkowania" DataMember4="SrodkiTrwale+Params.Odpowiedzialny" DataMember5="ActualDate.Actual"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" RowTypeName="SumaStawki"  GroupData0="Grupa" GroupLine="Grupa: {0}" ShowGroupSum="True" Sort="GrupaAmortyzacja">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." runat="server"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="Amortyzacja.Metoda" Caption="Metoda" Width="31" Total="Info"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Right" DataMember="Amortyzacja.Stawka" Caption="Stawka" Width="22"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Right" DataMember="Wartosc" Caption="Wartosc bilansowa" Total="Sum"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

